package com.vf106.tools.utils;

import android.content.Context;
import android.content.SharedPreferences;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.vf106.tools.App;
import com.vf106.tools.bean.BaseBean;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;

/**
 * Description:Shared Parameters tool class
 */
public final class SPUtils {
    private SharedPreferences sp;
    private static final String FILE_SP_NAME = "SpTools";
    private static SPUtils mSPUtils;

    public SPUtils() {
        sp = App.getInstance().getSharedPreferences(FILE_SP_NAME, Context.MODE_PRIVATE);
    }

    public static SPUtils getInstance() {
        if (mSPUtils == null) {
            synchronized (SPUtils.class) {
                if (mSPUtils == null) {
                    mSPUtils = new SPUtils();
                }
            }
        }
        return mSPUtils;
    }

    //    ---------------------  String ----------------------------

    public void put(String key, String value) {
        sp.edit().putString(key, value).apply();
    }

    public String getString(String key) {
        return getString(key, "");
    }

    public String getString(String key, String defaultValue) {
        return sp.getString(key, defaultValue);
    }


    //    ---------------------  int ----------------------------

    public void put(String key, int value) {
        sp.edit().putInt(key, value).apply();
    }


    public int getInt(String key) {
        return getInt(key, -1);
    }

    public int getInt(String key, int defaultValue) {
        return sp.getInt(key, defaultValue);
    }


    //    ---------------------  long ----------------------------

    public void put(String key, long value) {
        sp.edit().putLong(key, value).apply();
    }

    public long getLong(String key) {
        return getLong(key, -1L);
    }

    public long getLong(String key, long defaultValue) {
        return sp.getLong(key, defaultValue);
    }


    //    ---------------------  float ----------------------------

    public void put(String key, float value) {
        sp.edit().putFloat(key, value).apply();
    }

    public float getFloat(String key) {
        return getFloat(key, -1f);
    }

    public float getFloat(String key, float defaultValue) {
        return sp.getFloat(key, defaultValue);
    }


    //    ---------------------  boolean ----------------------------

    public void put(String key, boolean value) {
        sp.edit().putBoolean(key, value).apply();
    }

    public boolean getBoolean(String key) {
        return getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return sp.getBoolean(key, defaultValue);
    }

    //    ---------------------  Set ----------------------------

    public void put(String key, Set<String> values) {
        sp.edit().putStringSet(key, values).apply();
    }

    public Set<String> getStringSet(String key) {
        return getStringSet(key, Collections.<String>emptySet());
    }

    public Set<String> getStringSet(String key, Set<String> defaultValue) {
        return sp.getStringSet(key, defaultValue);
    }

    public void put(String key, List<BaseBean> values) {
        Gson gson = new Gson();
        String strJson = gson.toJson(values);
        sp.edit().putString(key, strJson)
                .apply();
    }

    public List<BaseBean> getList(String key) {
        List<BaseBean> mList = new ArrayList<>();
        String strJson = getString(key);
        if (null == strJson) {
            return mList;
        }
        Gson gson = new Gson();
        mList = gson.fromJson(strJson, new TypeToken<List<BaseBean>>() {
        }.getType());
        return mList;
    }

    public boolean contains(String key) {
        return sp.contains(key);
    }

    public void remove(String key) {
        sp.edit().remove(key).apply();
    }

    public void clear() {
        sp.edit().clear().apply();
    }
}
